<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Not Verified</title>
    <link rel="icon" href="{{ $app_setting['favicon'] }}" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .container {
            max-width: 600px;
            margin: 50px auto;
            background: #ffffff;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            padding: 20px;
            text-align: center;
        }

        .header {
            background: #5864ff;
            padding: 20px;
            color: #ffffff;
            border-radius: 10px 10px 0 0;
        }

        .header h1 {
            margin: 0;
            font-size: 24px;
        }

        .content {
            margin: 20px 0;
        }

        .content p {
            font-size: 16px;
            color: #555555;
            line-height: 1.6;
        }

        .content .btn {
            display: inline-block;
            margin-top: 20px;
            background-color: #0056b3;
            color: #ffffff;
            text-decoration: none;
            padding: 10px 20px;
            font-size: 16px;
            border-radius: 5px;
        }

        .content .btn:hover {
            background-color: #003d80;
        }

        .footer {
            margin-top: 20px;
            font-size: 14px;
            color: #777777;
        }

        .footer a {
            color: #0056b3;
            text-decoration: none;
        }
    </style>
</head>

<body>
    <div class="container">
        <div>
            <img src="{{ asset('assets/images/auth/logo.png') }}" alt="logo" width="200" class="mb-5">
        </div>
        <div class="header">
            <h3 class="fw-bolder">Action Required: Verify Your Email</h3>
        </div>
        <div class="content">
            <p class="fw-bold fs-6">Hello {{ Auth::user()->name }}</p>
            <p class="text-muted">We noticed that your email address has not been verified yet. To access your account
                and all features,
                please verify your email address by clicking the button below re-send the verification link.</p>
            <p class="text-muted">If you didn’t receive the email or the link has expired, you can request a new
                verification link below.
            </p>
            <form action="{{ route('verification.send') }}" method="POST">
                @csrf
                <button class="btn" style="background-color: #ff6f61;">Resend
                    Verification Email</button>
            </form>
        </div>
        <div class="footer">
            <p>If you have any questions, feel free to <a href="#">contact our support team</a>.</p>
            <p>Thank you,<br>The Valage na LMS Team</p>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4" crossorigin="anonymous">
    </script>
</body>

</html>
